<?php

namespace XFI\Import\Importer;

class vBulletin36 extends vBulletin
{
	public static function getListInfo()
	{
		return [
			'target' => 'XenForo',
			'source' => 'vBulletin 3.6',
		];
	}

	public function getSteps()
	{
		$steps = parent::getSteps();

		$removeSteps = [
			'visitorMessages',
			'threadPrefixes',
			'contentTags',
			'postEditHistory',
			'infractions',
			'captchaQuestions',
			'notices',
		];

		foreach ($removeSteps AS $step)
		{
			unset($steps[$step]);
		}

		// remove dependency on thread prefixes
		$steps['threads']['depends'] = ['forums'];

		return $steps;
	}

	protected function getFeeds()
	{
		return $this->sourceDb->fetchAll("
			SELECT *, 0 as prefixid
			FROM rssfeed
		");
	}

	protected function getCustomBbCodes()
	{
		return $this->sourceDb->fetchAll("
			SELECT *, '' AS options
			FROM bbcode
		");
	}
}
